# Задачи реализации: Автоматическая постановка задачи бухгалтерии при прикреплении файлов к договорам

> ПРД-001 | Repository: erp25-vendor | Решение: Подписка + Фоновое задание | Трудоёмкость: 3/10

## Фаза 1: Подготовка метаданных

- [ ] **1.1** Создать элемент НСИ в справочнике `РолиИсполнителей`
  - Наименование: `Бухгалтерия договоры реализации`
  - КраткоеПредставление: `Бухгалтерия дог. реализации` (до 50 символов)
  - `ИспользуетсяБезОбъектовАдресации` = `Истина`
  - `ИспользуетсяСОбъектамиАдресации` = `Ложь`
  - Табличная часть `Назначение` — оставить пустой; заполняется администратором отдельно
  - Критерий выполнения: элемент записан и доступен в форме выбора роли исполнителя при создании задачи

- [ ] **1.2** Создать общий модуль `ОбработчикЗадачПоФайламДоговоров`
  - Тип: серверный модуль
  - Свойство «Сервер»: `Истина`
  - Свойство «Вызов сервера»: `Ложь` (модуль не вызывается с клиента напрямую)
  - Свойство «Внешнее соединение»: `Ложь`
  - Критерий выполнения: модуль создан, синтаксическая проверка проходит

- [ ] **1.3** Создать подписку на событие `ПриЗаписиФайлаДоговора`
  - Источник: `Справочник.ДоговорыКонтрагентовПрисоединенныеФайлы`
  - Событие: `ПриЗаписи`
  - Обработчик: `ОбработчикЗадачПоФайламДоговоров.ПриЗаписиФайлаДоговора`
  - Критерий выполнения: подписка создана, обработчик указан корректно, конфигурация сохраняется без ошибок

## Фаза 2: Логика

- [ ] **2.1** Реализовать обработчик подписки `ПриЗаписиФайлаДоговора` в модуле `ОбработчикЗадачПоФайламДоговоров`
  - Алгоритм: см. design.md → Алгоритм 1
  - Контекст: Сервер (без контекста)
  - Сигнатура: `Процедура ПриЗаписиФайлаДоговора(Источник, Отказ) Экспорт`
  - Проверки: `ЭтоНовый()`, `ОбменДанными.Загрузка`, тип договора из перечня
  - Запуск: `ФоновыеЗадания.Выполнить(...)` с именем задания «ПРД-001: создание задачи по файлу договора»
  - Критерий выполнения: при добавлении файла к договору типа `СПокупателем` фоновое задание появляется в списке фоновых заданий

- [ ] **2.2** Реализовать экспортную процедуру `СоздатьЗадачуПоФайлуДоговора` в модуле `ОбработчикЗадачПоФайламДоговоров`
  - Алгоритм: см. design.md → Алгоритм 2
  - Контекст: Сервер (вызывается фоновым заданием)
  - Сигнатура: `Процедура СоздатьЗадачуПоФайлуДоговора(СсылкаНаФайл, СсылкаНаДоговор, ДатаСобытия) Экспорт`
  - Критерий выполнения: вызов процедуры вручную (из консоли) создаёт задачу `ЗадачаИсполнителя` с корректными реквизитами

- [ ] **2.3** Реализовать вспомогательную функцию `НайтиРольБухгалтерияДоговоры` в модуле `ОбработчикЗадачПоФайламДоговоров`
  - Алгоритм: см. design.md → Алгоритм 3
  - Контекст: Сервер
  - Возвращает: ссылку на `РолиИсполнителей` или `Неопределено`
  - Критерий выполнения: функция возвращает корректную ссылку после создания элемента НСИ в п. 1.1

- [ ] **2.4** Реализовать вспомогательную функцию `НайтиПриоритетВысокий` в модуле `ОбработчикЗадачПоФайламДоговоров`
  - Алгоритм: см. design.md → Алгоритм 4
  - Контекст: Сервер
  - Возвращает: ссылку на `Справочник.Приоритеты` или `Неопределено`
  - Критерий выполнения: функция возвращает ненулевую ссылку при наличии элемента «Высокий» в базе

- [ ] **2.5** Уточнить наличие реквизита `Приоритет` у объекта `Задачи.ЗадачаИсполнителя` в данной конфигурации
  - Открыть объект `Задача.ЗадачаИсполнителя` в конфигураторе и проверить список реквизитов
  - Если реквизит `Приоритет` отсутствует — удалить строку `НоваяЗадача.Приоритет = Приоритет` из Алгоритма 2 и исключить задачу 2.4
  - Критерий выполнения: решение принято и отражено в коде; в design.md внесена отметка о результате проверки

## Фаза 3: Права доступа

- [ ] **3.1** Убедиться, что общий модуль `ОбработчикЗадачПоФайламДоговоров` не требует отдельной настройки прав
  - Серверный модуль без контекста вызывается платформой в рамках подписки и фонового задания — вне ролевой модели пользователя
  - Критерий выполнения: фоновое задание запускается и завершается успешно под стандартным системным пользователем, без ошибок прав доступа

- [ ] **3.2** Настроить права на элемент `РолиИсполнителей` «Бухгалтерия договоры реализации» для роли, исполняющей обязанности бухгалтера
  - Права `Чтение` и `Просмотр` на `Справочник.РолиИсполнителей` уже существуют в типовых ролях
  - Убедиться, что роль «Бухгалтерия договоры реализации» отображается в форме выбора исполнителя задачи для пользователей с соответствующими правами
  - Критерий выполнения: сотрудник бухгалтерии видит входящую задачу в своём списке задач

## Фаза 4: Тестирование

- [ ] **4.1** Проверить основной сценарий (см. scenarios.md → Happy Path)
  - Открыть договор типа `СПокупателем`, перейти на вкладку «Файлы», добавить файл с диска
  - Дождаться завершения фонового задания (не более 30 секунд)
  - Убедиться, что задача появилась у исполнителей роли «Бухгалтерия договоры реализации»
  - Проверить: описание, приоритет, срок исполнения

- [ ] **4.2** Проверить сценарий A: договор типа `СПоставщиком`
  - Добавить файл к договору типа `СПоставщиком` — задача **не** должна создаться

- [ ] **4.3** Проверить сценарий B: типы `СДавальцем` и `СДавальцем2_5`
  - Добавить файл к договору каждого из двух типов — задача создаётся в обоих случаях

- [ ] **4.4** Проверить сценарий C: обновление существующего файла
  - Отредактировать и перезаписать файл, уже прикреплённый к договору `СПокупателем` — повторная задача **не** должна создаться

- [ ] **4.5** Проверить граничные случаи (см. scenarios.md → Граничные случаи)
  - Временно переименовать элемент «Бухгалтерия договоры реализации» → убедиться, что ошибка попадает в журнал регистрации, задача не создаётся

- [ ] **4.6** Регрессия: убедиться, что штатная работа с файлами договоров не нарушена
  - ЭДО-функционал (ОтправленПолученЭД, статусы) работает корректно
  - Электронные подписи, шифрование файлов работают корректно
  - Облачная синхронизация файлов не нарушена

## Фаза 5: Документирование

- [ ] **5.1** Добавить комментарии к процедурам модуля `ОбработчикЗадачПоФайламДоговоров` в соответствии со стандартом ИТС:
  - Над каждой экспортной процедурой/функцией — блок описания с указанием назначения и параметров
  - Над внутренними вспомогательными функциями — однострочный комментарий

- [ ] **5.2** Зафиксировать результат проверки п. 2.5 (наличие реквизита `Приоритет` у задачи) в design.md в разделе «Риски реализации»

- [ ] **5.3** При наличии отклонений от проектного решения (например, другое имя реквизита задачи) — внести соответствующие изменения в design.md

---

**Готово к сдаче, когда:**
- Все пункты Фаз 1–4 отмечены ✓
- Пройдены все приёмочные критерии из scenarios.md
