# Сценарии и приёмочные критерии: Автоматическая постановка задачи бухгалтерии при прикреплении файлов к договорам

## Основной сценарий (Happy Path)

**Действующее лицо:** Менеджер

| Шаг | Действие пользователя | Ожидаемый результат системы |
|-----|-----------------------|-----------------------------|
| 1 | Открывает карточку договора контрагента с типом «С покупателем» (`СПокупателем`) | Форма договора открыта, вкладка «Файлы» доступна |
| 2 | Переходит на вкладку «Файлы» и добавляет файл с диска (команда «Добавить файл с диска») | Файл добавлен, новая запись в справочнике `ДоговорыКонтрагентовПрисоединенныеФайлы` создана и записана |
| 3 | Продолжает работу — форма не блокируется | Подписка `ПриЗаписиФайлаДоговора` вызывается на сервере, проверяет условия, запускает фоновое задание и возвращает управление немедленно |
| 4 | — | В течение нескольких секунд фоновое задание создаёт задачу `ЗадачаИсполнителя` с описанием «К договору добавлены файлы, просьба проверить настройки справочника», адресованную роли «Бухгалтерия договоры реализации», с приоритетом «Высокий» и сроком +1 день |
| 5 | Сотрудник из состава роли «Бухгалтерия договоры реализации» открывает список задач | Новая задача отображается в списке входящих задач |

## Альтернативные сценарии

### Сценарий A: Файл добавлен к договору неподходящего типа

**Условие:** Пользователь добавляет файл к договору с типом, не входящим в `{СПокупателем, СДавальцем, СДавальцем2_5}` (например, `СПоставщиком` или `Импорт`).

**Поведение системы:** Подписка срабатывает, проверяет `ТипДоговора`, условие не выполнено — обработчик завершается без запуска фонового задания. Задача не создаётся. Пользователь не получает никакого сообщения; работа с формой не нарушается.

### Сценарий B: Файл добавлен через обмен данными

**Условие:** Новая запись в `ДоговорыКонтрагентовПрисоединенныеФайлы` создаётся в ходе загрузки данных через механизм обмена (`ОбменДанными.Загрузка = Истина`), а не действием пользователя.

**Поведение системы:** Обработчик подписки обнаруживает флаг загрузки и завершается без действий. Задача не создаётся. Механизм обмена данными не нарушается.

### Сценарий C: Существующий файл отредактирован и перезаписан

**Условие:** Пользователь редактирует ранее прикреплённый файл (например, загружает новую версию), при этом запись справочника `ДоговорыКонтрагентовПрисоединенныеФайлы` не является новой.

**Поведение системы:** Обработчик подписки проверяет `ЭтоНовый()` — значение `Ложь`. Обработчик завершается без запуска фонового задания. Задача не создаётся повторно.

### Сценарий D: Роль «Бухгалтерия договоры реализации» не найдена в справочнике

**Условие:** В справочнике `РолиИсполнителей` отсутствует элемент с наименованием «Бухгалтерия договоры реализации» (например, элемент не создан или помечен на удаление).

**Поведение системы:** Фоновое задание запускается штатно. При поиске роли запрос возвращает пустой результат. Фоновое задание записывает сообщение об ошибке в журнал регистрации с уровнем «Ошибка» и завершается без создания задачи. Сессия пользователя не затронута.

### Сценарий E: Фоновое задание завершилось с необработанной ошибкой

**Условие:** В ходе выполнения фонового задания произошло исключение (например, нарушение прав доступа или недоступность СУБД).

**Поведение системы:** Фоновое задание завершается с ошибкой, которая фиксируется в стандартном журнале фоновых заданий платформы. Задача не создаётся. Повторного запуска нет. Сессия пользователя не затронута — пользователь уже продолжил работу.

## Граничные случаи

| Ситуация | Ожидаемое поведение |
|----------|---------------------|
| Файл добавлен к договору типа `СДавальцем` | Задача создаётся — тип входит в допустимый перечень |
| Файл добавлен к договору типа `СДавальцем2_5` | Задача создаётся — тип входит в допустимый перечень |
| В справочнике «Приоритеты» отсутствует элемент «Высокий» | Задача создаётся, поле `Приоритет` остаётся пустым; в журнал ничего не пишется |
| Несколько файлов добавлены к одному договору подряд | Для каждого файла создаётся отдельная задача; дублирование задач — ожидаемое поведение в рамках данной задачи |
| Фоновые задания отключены на сервере | Фоновое задание не запускается; задача не создаётся; ошибка в журнале фоновых заданий; пользователь не уведомляется |
| Договор не найден через `ВладелецФайла` (пустая ссылка) | Обращение к `ВладелецФайла.ТипДоговора` вернёт пустое значение перечисления; условие FR-02 не выполнится; задача не создаётся |

## Приёмочные критерии (Definition of Done)

- [ ] При добавлении файла к договору типа `СПокупателем` задача появляется у исполнителей роли «Бухгалтерия договоры реализации» не позднее чем через 30 секунд
- [ ] При добавлении файла к договору типа `СДавальцем` задача создаётся аналогично сценарию для `СПокупателем`
- [ ] При добавлении файла к договору типа `СДавальцем2_5` задача создаётся аналогично сценарию для `СПокупателем`
- [ ] Описание задачи точно равно: «К договору добавлены файлы, просьба проверить настройки справочника»
- [ ] Приоритет задачи = «Высокий»
- [ ] Срок исполнения задачи = дата добавления файла + 1 календарный день (с точностью ±1 минута)
- [ ] При добавлении файла к договору типа `СПоставщиком` задача **не** создаётся
- [ ] При загрузке файла через обмен данными задача **не** создаётся
- [ ] При перезаписи существующего файла задача **не** создаётся повторно
- [ ] Форма договора не блокируется в момент добавления файла — пользователь может продолжать работу немедленно
- [ ] Нет регрессии: добавление файлов к договорам в штатном режиме работает как раньше (ЭДО, ЭП, облачная синхронизация не нарушены)
- [ ] Код оформлен согласно стандартам разработки (BSL, ИТС)
