# Функциональные требования: Автоматическая постановка задачи бухгалтерии при прикреплении файлов к договорам

## Роли

| Роль | Описание |
|------|----------|
| Менеджер | Добавляет файлы к договорам контрагентов |
| Бухгалтерия договоры реализации | Получает задачу и выполняет проверку настроек справочника |
| Администратор системы | Настраивает состав исполнителей роли «Бухгалтерия договоры реализации» |

## Функциональные требования

### FR-01: Обнаружение добавления нового файла к договору

**Описание:** Система должна реагировать на факт создания новой записи в справочнике `ДоговорыКонтрагентовПрисоединенныеФайлы`.

**Триггер:** Запись нового элемента справочника `ДоговорыКонтрагентовПрисоединенныеФайлы` (событие `ПриЗаписи`).

**Результат:** Выполняется проверка условий для создания задачи (FR-02).

**Ограничения:**
- Реакция срабатывает только при создании новой записи (`ЭтоНовый() = Истина`).
- При обновлении существующего файла (не новая запись) реакция не срабатывает.
- При загрузке через механизм обмена данными (`ОбменДанными.Загрузка = Истина`) реакция не срабатывает.

### FR-02: Проверка типа договора

**Описание:** Система должна определять тип договора-владельца добавленного файла и сравнивать его с допустимым перечнем.

**Триггер:** Выполняется автоматически в рамках обработки FR-01.

**Результат:** Если тип договора входит в перечень `{СПокупателем, СДавальцем, СДавальцем2_5}` — инициируется создание задачи (FR-03). Иначе — обработка завершается без действий.

**Ограничения:** Тип договора читается через реквизит `ВладелецФайла.ТипДоговора` присоединённого файла.

### FR-03: Асинхронное создание задачи

**Описание:** Система должна создавать задачу для роли «Бухгалтерия договоры реализации» асинхронно, не блокируя сессию пользователя.

**Триггер:** Выполняется автоматически по результату FR-02 при совпадении типа договора.

**Результат:** Запущено фоновое задание, которое создаёт объект `Задачи.ЗадачаИсполнителя` с заполненными реквизитами и записывает его.

**Ограничения:** Обработчик подписки передаёт управление немедленно после запуска фонового задания — пользователь не ожидает завершения создания задачи.

### FR-04: Содержание задачи

**Описание:** Создаваемая задача должна содержать фиксированный текст.

**Триггер:** Выполняется в рамках фонового задания (FR-03).

**Результат:** Поле `Описание` задачи заполнено значением: «К договору добавлены файлы, просьба проверить настройки справочника».

**Ограничения:** Текст фиксирован; не зависит от наименования файла или договора.

### FR-05: Адресация задачи

**Описание:** Задача должна быть адресована роли «Бухгалтерия договоры реализации» из справочника `РолиИсполнителей`.

**Триггер:** Выполняется в рамках фонового задания (FR-03).

**Результат:** Поле `РольИсполнителя` задачи заполнено ссылкой на элемент «Бухгалтерия договоры реализации» справочника `РолиИсполнителей`.

**Ограничения:** Элемент «Бухгалтерия договоры реализации» должен быть предварительно создан в справочнике `РолиИсполнителей` с флагом `ИспользуетсяБезОбъектовАдресации = Истина`. Состав исполнителей (табличная часть `Назначение`) настраивается администратором отдельно.

### FR-06: Приоритет задачи

**Описание:** Создаваемая задача должна иметь высокий приоритет.

**Триггер:** Выполняется в рамках фонового задания (FR-03).

**Результат:** Поле `Приоритет` задачи заполнено ссылкой на элемент «Высокий» из справочника `Приоритеты`.

**Ограничения:** Поиск выполняется по наименованию «Высокий»; если элемент не найден — задача создаётся без приоритета (поле остаётся пустым), ошибка не прерывает выполнение.

### FR-07: Срок исполнения задачи

**Описание:** Срок исполнения задачи должен составлять 1 календарный день с момента добавления файла.

**Триггер:** Выполняется в рамках фонового задания (FR-03).

**Результат:** Поле `СрокИсполнения` задачи заполнено значением: дата и время добавления файла + 86 400 секунд (1 календарный день).

**Ограничения:** Используется календарный день (не рабочий). Дата и время добавления файла — это значение `ТекущаяДата()` в момент срабатывания обработчика подписки, переданное в фоновое задание как параметр.

## Нефункциональные требования

### NFR-01: Производительность

Обработчик подписки должен завершаться за время, не превышающее стандартный overhead подписки (единицы миллисекунд): проверка условий и запуск фонового задания не содержат запросов к базе данных в синхронной части. Все операции с базой данных (чтение роли, приоритета, запись задачи) выполняются в фоновом задании асинхронно.

### NFR-02: Совместимость с обновлениями

Решение реализуется через новые объекты конфигурации (подписка, общий модуль), не изменяя типовые объекты. Риск конфликта при обновлении конфигурации минимален. Необходимо контролировать переименование объектов `ДоговорыКонтрагентовПрисоединенныеФайлы` и изменение состава `Перечисление.ТипыДоговоров` при мажорных обновлениях.

### NFR-03: Надёжность

Решение не гарантирует доставку: сбой фонового задания или перезапуск сервера в момент выполнения приведёт к потере задачи без уведомления. Это известное ограничение выбранного подхода, принятое как допустимое в рамках задачи ПРД-001.

## Матрица требований ↔ объекты

| Требование | Объект метаданных | Действие |
|------------|-------------------|----------|
| FR-01 | `ПриЗаписиФайлаДоговора` (Подписка) | Создать |
| FR-01, FR-02, FR-03 | `ОбработчикЗадачПоФайламДоговоров` (Общий модуль) | Создать |
| FR-02 | `ДоговорыКонтрагентов.ТипДоговора` | Читать (без изменений) |
| FR-03, FR-04, FR-05, FR-06, FR-07 | `Задачи.ЗадачаИсполнителя` | Использовать (платформенный механизм) |
| FR-05 | `РолиИсполнителей` | Добавить элемент НСИ |
| FR-06 | `Справочник.Приоритеты` | Читать (без изменений) |
