# Proposal: Автоматическая постановка задачи бухгалтерии при прикреплении файлов к договорам

## Контекст

Менеджеры прикрепляют файлы к договорам контрагентов типа «Реализация» и «Приём в переработку» — в этих случаях бухгалтерской службе необходимо проверить настройки справочника. Сейчас оповещение происходит вручную или не происходит вовсе, что ведёт к потере уведомлений и задержкам в обработке.

## Проблема

Бухгалтерская служба не получает автоматического уведомления о том, что к договору типа «Реализация» или «Приём в переработку» добавлен файл. Сотрудник, добавивший файл, должен самостоятельно помнить о необходимости уведомить бухгалтерию — что ненадёжно и нарушает бизнес-процесс.

## Цель изменения

После реализации при добавлении файла к договору указанных типов в системе автоматически появляется задача с высоким приоритетом и сроком 1 день, адресованная роли «Бухгалтерия договоры реализации». Инициатор не ждёт — задача создаётся асинхронно в течение нескольких секунд.

## Выбранный подход

Подписка на событие `ПриЗаписи` справочника `ДоговорыКонтрагентовПрисоединенныеФайлы` проверяет тип договора-владельца и при соответствии условию запускает фоновое задание. Фоновое задание создаёт задачу через механизм задач платформы 1С (`Задачи.ЗадачаИсполнителя`). Выбран единственный предложенный вариант — он минимален по составу новых объектов, не блокирует сессию пользователя и не требует регламентного задания.

## Границы изменения

**В рамках задачи:**
- Создание подписки на событие `ПриЗаписи` справочника `ДоговорыКонтрагентовПрисоединенныеФайлы`
- Создание общего модуля `ОбработчикЗадачПоФайламДоговоров` (серверный, без контекста)
- Добавление нового элемента НСИ «Бухгалтерия договоры реализации» в справочник `РолиИсполнителей`
- Постановка задачи только при добавлении нового файла (не при обновлении существующего)
- Обработка трёх типов договоров: `СПокупателем`, `СДавальцем`, `СДавальцем2_5`

**Вне рамок задачи:**
- Изменение форм справочников `ДоговорыКонтрагентов` и `ДоговорыКонтрагентовПрисоединенныеФайлы`
- Отслеживание и хранение истории созданных задач по файлам
- Повторная отправка задачи при сбое фонового задания (механизм гарантированной доставки)
- Настройка состава исполнителей роли «Бухгалтерия договоры реализации» — выполняется администратором вручную
- Уведомление инициатора об успешном создании задачи

## Затронутые объекты конфигурации

| Объект | Тип | Действие |
|--------|-----|----------|
| `ДоговорыКонтрагентовПрисоединенныеФайлы` | Справочник | Без изменений (точка подключения подписки) |
| `ДоговорыКонтрагентов` | Справочник | Без изменений (читается `ТипДоговора`) |
| `РолиИсполнителей` | Справочник | Добавить элемент НСИ |
| `ПриЗаписиФайлаДоговора` | Подписка на событие | Создать |
| `ОбработчикЗадачПоФайламДоговоров` | Общий модуль | Создать |
